﻿using System.Threading;

namespace MonitorCoordination
{
    // Listing 16-14. Koordynacja wątków przy wykorzystaniu klasy Monitor
    class WaitForIt
    {
        private bool canGo;
        private object lockObject = new object();
        public void WaitUntilReady()
        {
            lock (lockObject)
            {
                while (!canGo)
                {
                    Monitor.Wait(lockObject);
                }
            }
        }
        public void GoNow()
        {
            lock (lockObject)
            {
                canGo = true;
                // Obudź mnie, zanim pójdziesz...
                Monitor.PulseAll(lockObject);
            }
        }
    }
}
